using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Resources;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using CONTROLS = gov.va.med.vbecs.GUI.controls;
using TaskStatus = gov.va.med.vbecs.Common.TaskStatus;
using TestingMethod = gov.va.med.vbecs.Common.TestingMethod;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// CellChangedEventHandler Delegate
	/// </summary>
	public delegate void CellChangedEventHandler(object sender, EventArgs e);

	/// <summary>
	/// Summary description for DataGridABORh.
	/// </summary>
	public class DataGridAboRH : Panel
	{
		private System.Guid _parentFormGuid = System.Guid.Empty;
		private Hashtable resultLookup;
		private DataGridTableStyle _dgTableStyle;
		private DataGridTextBoxColumn _dcTextBox;
		private DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		private VbecsDataGrid dgABORh;
		private Button btnClear;
		private ToolTip toolTip1;
		private IContainer components;
		private Division _division;
		private DataRow _drABORh;
		private string _validEntries;
		private OrderedTest _orderedTest;
		private ComboBoxLookup cmbBoxAboComment;
		private ComboBoxLookup cmbBoxRhComment;
		private string _testingTech;
		private DateTime _testingDate;
		private bool _performDControl;
		private bool _performAntiAB;
		private char _testStatusCode;
        //CR 3412
        private Common.UserRoleType _userRole;

		/// <summary>
		/// enableInvalidation
		/// </summary>
		public bool enableInvalidation;

		/// <summary>
		/// CellChanged Event
		/// </summary>
		public event CellChangedEventHandler CellChanged;

		/// <summary>
		/// RowVersionChanged Event
		/// </summary>
		public event RowVersionChangedEventHandler RowVersionChanged;
		private bool _keyPressEventHandled;

		/// <summary>
		/// DataGridAboRH class constructor. Creates an instance of the class.
		/// </summary>
		public DataGridAboRH()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			InitializeGrid();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new Container();
			ResourceManager resources = new ResourceManager(typeof(DataGridAboRH));
			this.dgABORh = new VbecsDataGrid();
			this.btnClear = new Button();
			this.toolTip1 = new ToolTip(this.components);
			this.cmbBoxAboComment = new ComboBoxLookup();
			this.cmbBoxRhComment = new ComboBoxLookup();
			((ISupportInitialize)(this.dgABORh)).BeginInit();
			this.SuspendLayout();
			// 
			// dgABORh
			// 
			this.dgABORh.AllowSorting = false;
			this.dgABORh.Anchor = (((AnchorStyles.Top | AnchorStyles.Bottom) 
				| AnchorStyles.Left) 
				| AnchorStyles.Right);
			this.dgABORh.CaptionFont = new Font("Arial", 8.25F, FontStyle.Bold, GraphicsUnit.Point, ((Byte)(0)));
			this.dgABORh.CaptionText = "Patient ABO/Rh (ABORH)";
			this.dgABORh.CaptionVisible = false;
			this.dgABORh.DataMember = string.Empty;
			this.dgABORh.Font = new Font("Arial", 8.25F, FontStyle.Regular, GraphicsUnit.Point, ((Byte)(0)));
			this.dgABORh.HeaderFont = new Font("Arial", 8.25F, FontStyle.Regular, GraphicsUnit.Point, ((Byte)(0)));
			this.dgABORh.HeaderForeColor = SystemColors.ControlText;
			this.dgABORh.Name = "dgABORh";
			this.dgABORh.RowHeadersVisible = false;
			this.dgABORh.Size = new Size(492, 96);
			this.dgABORh.TabIndex = 42;
			this.dgABORh.ToolTipColumn = -1;
			this.dgABORh.CurrentCellChanged += new EventHandler(this.dgABORh_CurrentCellChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = (AnchorStyles.Top | AnchorStyles.Right);
			this.btnClear.Image = ((Bitmap)(resources.GetObject("btnClear.Image")));
			this.btnClear.Location = new Point(470, 1);
			this.btnClear.Name = "btnClear";
			this.btnClear.Size = new Size(20, 20);
			this.btnClear.TabIndex = 43;
			this.toolTip1.SetToolTip(this.btnClear, StrRes.Tooltips.Common.ClearResults().ResString);
			this.btnClear.Click += new EventHandler(this.btnClear_Click);
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// cmbBoxAboComment
			// 
			this.cmbBoxAboComment.MaxLength = 255;
			this.cmbBoxAboComment.Name = "cmbBoxAboComment";
			this.cmbBoxAboComment.TabIndex = 0;
			this.cmbBoxAboComment.Width = 108;
			this.cmbBoxAboComment.Validating += new CancelEventHandler(this.cmbBoxAboComment_Validating);
			// 
			// cmbBoxRhComment
			// 
			this.cmbBoxRhComment.MaxLength = 255;
			this.cmbBoxRhComment.Name = "cmbBoxRhComment";
			this.cmbBoxRhComment.TabIndex = 0;
			this.cmbBoxRhComment.Width = 103;
			this.cmbBoxRhComment.Validating += new CancelEventHandler(this.cmbBoxRhComment_Validating);
			// 
			// DataGridAboRH
			// 
			this.Controls.AddRange(new Control[] {
													 this.btnClear,
													 this.dgABORh});
			this.Font = new Font("Arial", 8.25F, FontStyle.Regular, GraphicsUnit.Point, ((Byte)(0)));
			this.Name = "DataGridAboRH";
			this.Size = new Size(492, 96);
			((ISupportInitialize)(this.dgABORh)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Calls the method to create a hash table of testing results, creates the blood unit test table, 
		/// populates the table with the selected units, and sets the current cell to allow editing.
		/// </summary>
		private void InitializeGrid()
		{
			this.dgABORh.CaptionVisible = true;
			this.dgABORh.Enter += new EventHandler(dgABORh_Enter);
			this.dgABORh.Leave += new EventHandler(dgABORh_Leave);
			this.dgABORh.LostFocus +=new EventHandler(dgABORh_LostFocus);
			this.dgABORh.SizeChanged +=new EventHandler(dgABORh_SizeChanged);
			this.dgABORh.NextCell += new controls.NextCellEventHandler(FindNextCell);
			//			this.dgABORh.Direction = GridDirection.Right;
			//
			InitializeLookup();
			AddCustomDataTableStyle();
			this._keyPressEventHandled = false;
		}

		#region Locking

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		public event EventHandler UserActivity;

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		protected void OnUserActivity()
		{
			if (this.UserActivity != null)
				this.UserActivity(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// Guid of the control's container - needed for locking
		/// </summary>
		public System.Guid ParentFormGuid
		{
			get
			{
				if (this._parentFormGuid == System.Guid.Empty)
				{
					throw new BOL.BusinessObjectException("Locking Requirement missing -- ParentFormGuid not set.");
				}
				return(this._parentFormGuid);
			}
			set
			{
				this._parentFormGuid = value;
			}
		}

		#endregion


		/// <summary>
		/// Set or get the division code
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._division.DivisionCode;
			}
			set
			{
				if (value != null)
				{
					this._division = new Division(value);
					if (this._division.ServiceTypeIndicator == true)
					{
						DataTable dtDailyQCReagentTypes = BOL.ReagentType.GetDailyQCReagentTypes(Common.LogonUser.LogonUserDivisionCode);

						if (dtDailyQCReagentTypes.Select(TABLE.ReagentType.ReagentTypeId + " = " + (int)Common.WeakDTestReagents.AntiDControl).Length > 0)
							_performDControl = true;
						else
							_performDControl = false;

						if (dtDailyQCReagentTypes.Select(TABLE.ReagentType.ReagentTypeId + " = " + (int)Common.ReagentType.AntiAB).Length > 0)
							_performAntiAB = true;
						else
							_performAntiAB = false;
					}
					else
					{
						_performDControl = false;
						_performAntiAB = false;
					}
				}
			}
		}

		/// <summary>
		/// Get the valid entries description for grid cell
		/// </summary>
		public string ValidEntries
		{
			get
			{
				return this._validEntries;
			}
		}

		/// <summary>
		/// Set the OrderedTest object associated with this test
		/// </summary>
		public OrderedTest OrderedTest
		{
			set
			{
				this._orderedTest = value;
			}
			get
			{
				return this._orderedTest;
			}
		}

		/// <summary>
		/// Get or set the testing tech
		/// </summary>
		public string TestingTech
		{
			get
			{
				return this._testingTech;
			}
			set
			{
				this._testingTech = value;
			}
		}

		/// <summary>
		/// The date of test
		/// </summary>
		public DateTime TestingDate
		{
			get
			{
				return this._testingDate;
			}
			set
			{
				this._testingDate = value;
			}
		}

		/// <summary>
		/// Get the name of the qc rack
		/// </summary>
		public string RackName
		{
			get
			{
				if (this._drABORh.IsNull(TABLE.Rack.RackGuid) == false)
				{
					BOL.Rack rack = new BOL.Rack((Guid)this._drABORh[TABLE.Rack.RackGuid]);
					return rack.RackName;
				}
				else
					return string.Empty;
			}
		}

        /// <summary>
        /// CR 3412
        /// </summary>
        public Common.UserRoleType UserRole
        {
            get
            {
                return this._userRole;
            }

            set
            {
                this._userRole = value;
            }
        }

		/// <summary>
		/// Update row version when the part of the order (TAS or ABS) has been invalidated
		/// </summary>
		public byte[] RowVersionOrderedTest
		{
			set
			{
				this._drABORh[ARTIFICIAL.OrderedTestRowVersion] = value;
				this.OrderedTest.RowVersion = value;
				if (this.IsGridPartiallyCompleted() == false)
				{
					_drABORh[ARTIFICIAL.AntiAGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.AntiBGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.AntiABGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.A1CellsGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.BCellsGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.AntiDGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.ControlDGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.AboInterpGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.RhInterpGuid] = DBNull.Value;
					_drABORh[ARTIFICIAL.AntiARowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.AntiBRowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.AntiABRowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.A1CellsRowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.BCellsRowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.AntiDRowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.ControlDRowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.AboInterpRowVersion] = DBNull.Value;
					_drABORh[ARTIFICIAL.RhInterpRowVersion] = DBNull.Value;
				}
			}
		}

		/// <summary>
		/// Invoke cell changed event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnCellChanged(EventArgs e)
		{
			if (CellChanged != null)
				CellChanged(this.dgABORh, e);

			this.OnUserActivity();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates a hash table of testing results.
		/// </summary>
		private void InitializeLookup()
		{
			// Fill hashtable with the "Positive" and "Negative" values of each test result
			resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add(string.Empty, "X");
			resultLookup.Add("X", "X");
			
			// Positive results
			resultLookup.Add("H", "P");
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");
			resultLookup.Add("P", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
			resultLookup.Add("N", "N");
		}

		/// <summary>
		/// Creates the ABO/Rh table that is used as a datasource for the datagrid. This method
		/// also creates one row in this table that allows user to enter test results.
		/// BR_52.01
		/// </summary>
		/// <returns></returns>
		public DataTable CreateAboRHTable(OrderedTest test, Guid rackGuid, string previousABO, string previousRh)
		{
			bool _performDControl = true;
			bool _performAntiAB = true;
			bool aboResultsExist = false;

			this._orderedTest = test;

			DataTable dt = new DataTable("ABORh");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add(TABLE.ValidAboResult.AntiA, typeof(string));
			dt.Columns.Add(TABLE.ValidAboResult.AntiB, typeof(string));
			dt.Columns.Add(TABLE.ValidAboResult.AntiAB, typeof(string));
			dt.Columns.Add(ARTIFICIAL.A1Cells, typeof(string));
			dt.Columns.Add(ARTIFICIAL.BCells, typeof(string));
			dt.Columns.Add(TABLE.ValidRhResult.AntiD, typeof(string));
			dt.Columns.Add(ARTIFICIAL.ControlD, typeof(string));			
			dt.Columns.Add(ARTIFICIAL.AboInterp, typeof(string));			
			dt.Columns.Add(ARTIFICIAL.RhInterp, typeof(string));			
			dt.Columns.Add(ARTIFICIAL.AboComment, typeof(string));
			dt.Columns.Add(ARTIFICIAL.RhComment, typeof(string));
			dt.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderableTest.OrderableTestId);
			dt.Columns.Add(ARTIFICIAL.InitialABO, typeof(string));
			dt.Columns.Add(ARTIFICIAL.InitialRh, typeof(string));
			dt.Columns.Add(ARTIFICIAL.SystemABO, typeof(string));
			dt.Columns.Add(ARTIFICIAL.SystemRh, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AntiASave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AntiBSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AntiABSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.A1CellsSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.BCellsSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AntiDSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ControlDSave, typeof(bool));			
			dt.Columns.Add(ARTIFICIAL.AboInterpSave, typeof(bool));			
			dt.Columns.Add(ARTIFICIAL.RhInterpSave, typeof(bool));	
			dt.Columns.Add(ARTIFICIAL.AntiAGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AntiBGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AntiABGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.A1CellsGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.BCellsGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AntiDGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.ControlDGuid, typeof(Guid));			
			dt.Columns.Add(ARTIFICIAL.AboInterpGuid, typeof(Guid));			
			dt.Columns.Add(ARTIFICIAL.RhInterpGuid, typeof(Guid));	
			dt.Columns.Add(ARTIFICIAL.AntiARowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AntiBRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AntiABRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.A1CellsRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.BCellsRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AntiDRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.ControlDRowVersion, typeof(byte[]));			
			dt.Columns.Add(ARTIFICIAL.AboInterpRowVersion, typeof(byte[]));			
			dt.Columns.Add(ARTIFICIAL.RhInterpRowVersion, typeof(byte[]));	
			dt.Columns.Add(TABLE.CannedComment.CannedCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedTest.CprsOrderNumber);
			dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AboRhInconclusiveException, typeof(ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.AboRhDiscrepancyException, typeof(ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.RepeatAboRhDiscrepancyException, typeof(ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.EmergencyIssueExceptions, typeof(ArrayList));
			dt.Columns.Add(TABLE.SpecimenTest.CorrectedResultIndicator, typeof(bool));	
			dt.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			dt.Columns.Add(TABLE.SpecimenTest.AboRhChangeIndicator, typeof(bool));	

			//this columns should always be the last columns of the grid
			//when adding new columns please make sure that they are added before ARTIFICIAL.IndicatorMessage
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));  

			if (this._division.ServiceTypeIndicator == true)
			{
				DataTable dtDailyQCReagentTypes = BOL.ReagentType.GetDailyQCReagentTypes(Common.LogonUser.LogonUserDivisionCode);

				if (dtDailyQCReagentTypes.Select(TABLE.ReagentType.ReagentTypeId + " = " + (int)Common.WeakDTestReagents.AntiDControl).Length > 0 ||
					this.OrderedTest.OrderableTest.IndexOf("Repeat") != -1)
					_performDControl = true;
				else
					_performDControl = false;

				if (dtDailyQCReagentTypes.Select(TABLE.ReagentType.ReagentTypeId + " = " + (int)Common.ReagentType.AntiAB).Length > 0 ||
					this.OrderedTest.OrderableTest.IndexOf("Repeat") != -1)
					_performAntiAB = true;
				else
					_performAntiAB = false;
			}

			DataRow dr = dt.NewRow();
			dr[TABLE.Patient.PatientGuid] = test.Patient.PatientGuid;
			dr[TABLE.PatientSpecimen.PatientSpecimenGuid] = test.Specimen.SpecimenGuid;
			dr[TABLE.OrderedTest.OrderedTestGuid] = test.OrderedTestGuid;
			dr[TABLE.OrderableTest.OrderableTestId] = test.OrderableTestId;
			dr[ARTIFICIAL.OrderedTestRowVersion] = test.RowVersion;
			dr[ARTIFICIAL.Indicator] = string.Empty;
			dr[ARTIFICIAL.InitialABO] = previousABO;
			dr[ARTIFICIAL.InitialRh] = previousRh;

			//veryfing if there are any Abo/Rh results in the database
			//if not than treat this test as not started (for TAS only)
			DataTable dtSpecimenTests = BOL.OrderedTest.GetTestResultsForTask(test.OrderedTestGuid);
			//if (dtSpecimenTests.Select(TABLE.BloodTestType.BloodTestName + " LIKE '*Anti A*'").Length > 0)
			//CRT - 101405 - If its Transfusion-Only - we won't have an Anti A, so we should look for interp instead??
			if (dtSpecimenTests.Select(TABLE.BloodTestType.BloodTestName + " LIKE 'ABO Interp'").Length > 0)
				aboResultsExist = true;

			if ((aboResultsExist == true &&
				test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected)) ||
				test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				this._testStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted);
			}

			if (this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) &&
				aboResultsExist == true)
			{
				dr[TABLE.ValidAboResult.AntiA] = DBNull.Value;
				dr[TABLE.ValidAboResult.AntiB] = DBNull.Value;
				dr[TABLE.ValidAboResult.AntiAB] = DBNull.Value;
				dr[ARTIFICIAL.A1Cells] = DBNull.Value;
				dr[ARTIFICIAL.BCells] = DBNull.Value;
				dr[TABLE.ValidRhResult.AntiD] = DBNull.Value;
				dr[ARTIFICIAL.ControlD] = DBNull.Value;
				dr[ARTIFICIAL.AntiASave] = false;
				dr[ARTIFICIAL.AntiBSave] = false;
				dr[ARTIFICIAL.AntiABSave] = false;
				dr[ARTIFICIAL.A1CellsSave] = false;
				dr[ARTIFICIAL.BCellsSave] = false;
				dr[ARTIFICIAL.AntiDSave] = false;
				dr[ARTIFICIAL.ControlDSave] = false;
			}
			else
			{
				if (this._division.ServiceTypeIndicator == true)
				{
					dr[TABLE.ValidAboResult.AntiA] = string.Empty;
					dr[TABLE.ValidAboResult.AntiB] = string.Empty;

					if (_performAntiAB == true)
					{
						dr[TABLE.ValidAboResult.AntiAB] = string.Empty;
						dr[ARTIFICIAL.AntiABSave] = true;
					}
					else
					{
						dr[TABLE.ValidAboResult.AntiAB] = DBNull.Value;
						dr[ARTIFICIAL.AntiABSave] = false;
					}

					dr[ARTIFICIAL.A1Cells] = string.Empty;
					dr[ARTIFICIAL.BCells] = string.Empty;
					dr[TABLE.ValidRhResult.AntiD] = string.Empty;

					if (_performDControl == true)
					{
						dr[ARTIFICIAL.ControlD] = string.Empty;
						dr[ARTIFICIAL.ControlDSave] = true;
					}
					else
					{
						dr[ARTIFICIAL.ControlD] = DBNull.Value;
						dr[ARTIFICIAL.ControlDSave] = false;
					}
					dr[ARTIFICIAL.AntiASave] = true;
					dr[ARTIFICIAL.AntiBSave] = true;
					dr[ARTIFICIAL.A1CellsSave] = true;
					dr[ARTIFICIAL.BCellsSave] = true;
					dr[ARTIFICIAL.AntiDSave] = true;
				}
				else
				{
					dr[TABLE.ValidAboResult.AntiA] = DBNull.Value;
					dr[TABLE.ValidAboResult.AntiB] = DBNull.Value;
					dr[TABLE.ValidAboResult.AntiAB] = DBNull.Value;
					dr[ARTIFICIAL.A1Cells] = DBNull.Value;
					dr[ARTIFICIAL.BCells] = DBNull.Value;
					dr[TABLE.ValidRhResult.AntiD] = DBNull.Value;
					dr[ARTIFICIAL.ControlD] = DBNull.Value;
					dr[ARTIFICIAL.AntiASave] = false;
					dr[ARTIFICIAL.AntiBSave] = false;
					dr[ARTIFICIAL.AntiABSave] = false;
					dr[ARTIFICIAL.A1CellsSave] = false;
					dr[ARTIFICIAL.BCellsSave] = false;
					dr[ARTIFICIAL.AntiDSave] = false;
					dr[ARTIFICIAL.ControlDSave] = false;
				}
			}

			dr[TABLE.ValidAboResult.AboInterp] = string.Empty;
			dr[TABLE.ValidRhResult.RhInterp] = string.Empty;
			dr[ARTIFICIAL.AboInterpSave] = true;
			dr[ARTIFICIAL.RhInterpSave] = true;
			dr[ARTIFICIAL.AboComment] = string.Empty;
			dr[ARTIFICIAL.RhComment] = string.Empty;
			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[TABLE.OrderedTest.CprsOrderNumber] = test.CPRSOrderNumber;

			if (rackGuid != Guid.Empty)
				dr[TABLE.Rack.RackGuid] = rackGuid;

			if (test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = true;
			else
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = false;

			dr[ARTIFICIAL.IndicatorMessage] = string.Empty;

			dt.Rows.Add(dr);

			this.dgABORh.ToolTipColumn = dt.Columns.Count - 1;

			return dt;
		}

		/// <summary>
		/// Sets the data source for a grid. Transfers DataTable to a DataView and passes it as
		/// a source for a grid.
		/// </summary>
		/// <param name="dt"></param>
		public void SetDataSource(DataTable dt)
		{
			if (dt.Rows.Count == 0)
			{
				this.dgABORh.ColumnHeadersVisible = false;
				this.dgABORh.DataSource = dt.DefaultView;
				this.btnClear.Enabled = false;
				enableInvalidation = false;
			}
			else
			{
				this.btnClear.Enabled = true;
				enableInvalidation = true;
				this.dgABORh.ColumnHeadersVisible = true;
				this.dgABORh.DataSource = dt.DefaultView;
				((DataView)dgABORh.DataSource).AllowNew = false;
				((DataView)dgABORh.DataSource).AllowDelete = false;
				this.cmbBoxAboComment.SelectedIndex = -1;
				this.cmbBoxRhComment.SelectedIndex = -1;

				this._drABORh = dt.Rows[0];
				UpdateIndicator();
			}
		}

		/// <summary>
		/// Enables or disables the grid
		/// </summary>
		/// <param name="status"></param>
		public void SetGridStatus(bool status)
		{
			this.dgABORh.Enabled = status;
		}

		/// <summary>
		/// Check if there are any results from previous testing
		/// </summary>
		/// <returns></returns>
		private bool IsGridPartiallyCompleted()
		{
			if ((bool)_drABORh[ARTIFICIAL.AntiASave] == false && _drABORh.IsNull(TABLE.ValidAboResult.AntiA) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.AntiBSave] == false && _drABORh.IsNull(TABLE.ValidAboResult.AntiB) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.AntiABSave] == false && _drABORh.IsNull(TABLE.ValidAboResult.AntiAB) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.A1CellsSave] == false && _drABORh.IsNull(ARTIFICIAL.A1Cells) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.BCellsSave] == false && _drABORh.IsNull(ARTIFICIAL.BCells) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.AntiDSave] == false && _drABORh.IsNull(TABLE.ValidRhResult.AntiD) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.ControlDSave] == false && _drABORh.IsNull(ARTIFICIAL.ControlD) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.AboInterpSave] == false && _drABORh.IsNull(TABLE.ValidAboResult.AboInterp) == false)
				return true;
			if ((bool)_drABORh[ARTIFICIAL.RhInterpSave] == false && _drABORh.IsNull(TABLE.ValidRhResult.RhInterp) == false)
				return true;

			return false;
		}

		/// <summary>
		/// Checks if the grid is empty
		/// </summary>
		/// <returns></returns>
		public bool IsGridEmpty()
		{
			if (((DataView)this.dgABORh.DataSource).Table.Rows.Count == 0)
			{
				return true;
			}

			if (this._division.ServiceTypeIndicator == true ||
				this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				if (this._drABORh[TABLE.ValidAboResult.AntiA].ToString() != string.Empty ||
					this._drABORh[TABLE.ValidAboResult.AntiB].ToString() != string.Empty ||
					this._drABORh[TABLE.ValidAboResult.AntiAB].ToString() != string.Empty ||
					this._drABORh[ARTIFICIAL.A1Cells].ToString() != string.Empty ||
					this._drABORh[ARTIFICIAL.BCells].ToString() != string.Empty ||
					this._drABORh[TABLE.ValidRhResult.AntiD].ToString() != string.Empty ||
					this._drABORh[ARTIFICIAL.ControlD].ToString() != string.Empty ||
					this._drABORh[TABLE.ValidAboResult.AboInterp].ToString() != string.Empty ||
					this._drABORh[TABLE.ValidRhResult.RhInterp].ToString() != string.Empty)
				{
					return false;
				}
				else
				{
					return true;
				}	
			}
			else //transfusion only
			{
				if (this._drABORh[TABLE.ValidAboResult.AboInterp].ToString() != string.Empty ||
					this._drABORh[TABLE.ValidRhResult.RhInterp].ToString() != string.Empty)
				{
					return false;
				}
				else
				{
					return true;
				}
			}
		}

		/// <summary>
		/// Check if data on the grid is ready to be saved to the database.
		/// </summary>
		/// <returns></returns>
		public bool IsReadyToSave()
		{
			if (((DataView)this.dgABORh.DataSource).Table.Rows.Count == 0)
			{
				return true;
			}

			if (this._division.ServiceTypeIndicator == true ||
				this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				if (this._drABORh[ARTIFICIAL.Indicator].ToString() == "E")
				{
					return false;
				}
				else if (IsGridEmpty() == true)
				{
					return false;
				}
				else
				{
					return true;
				}
			}
			else //transfusion only
			{
				if (this._drABORh[ARTIFICIAL.Indicator].ToString() == "V" ||
					this._drABORh[ARTIFICIAL.Indicator].ToString() == "W")
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}

		/// <summary>
		/// Clears the test results from the grid. Restores the initial state of the grid
		/// and updates indicator.
		/// </summary>
		public void ClearTestResults(bool clearAll)
		{
			if (this._drABORh != null)
			{
				this.dgABORh.SetCurrentCell(0, 10);

				if (this._division.ServiceTypeIndicator == true ||
					this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					if ((bool)this._drABORh[ARTIFICIAL.AntiASave] == true ||
						clearAll == true)
					{
						if (this._drABORh.IsNull(TABLE.ValidAboResult.AntiA) == false)
						{
							this._drABORh[TABLE.ValidAboResult.AntiA] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.AntiAGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiARowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiASave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.AntiBSave] == true ||
						clearAll == true)
					{
						if (this._drABORh.IsNull(TABLE.ValidAboResult.AntiB) == false)
						{
							this._drABORh[TABLE.ValidAboResult.AntiB] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.AntiBGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiBRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiBSave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.AntiABSave] == true ||
						clearAll == true)
					{
						if (this._performAntiAB == false)
						{
							this._drABORh[TABLE.ValidAboResult.AntiAB] = DBNull.Value;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.AntiABGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiABRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiABSave] = false;
							}
						}
						else if (this._drABORh.IsNull(TABLE.ValidAboResult.AntiAB) == false)
						{
							this._drABORh[TABLE.ValidAboResult.AntiAB] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.AntiABGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiABRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiABSave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.A1CellsSave] == true ||
						clearAll == true)
					{
						if (this._drABORh.IsNull(ARTIFICIAL.A1Cells) == false)
						{
							this._drABORh[ARTIFICIAL.A1Cells] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.A1CellsGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.A1CellsRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.A1CellsSave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.BCellsSave] == true ||
						clearAll == true)
					{
						if (this._drABORh.IsNull(ARTIFICIAL.BCells) == false)
						{
							this._drABORh[ARTIFICIAL.BCells] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.BCellsGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.BCellsRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.BCellsSave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.AntiDSave] == true ||
						clearAll == true)
					{
						if (this._drABORh.IsNull(TABLE.ValidRhResult.AntiD) == false)
						{
							this._drABORh[TABLE.ValidRhResult.AntiD] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.AntiDGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiDRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AntiDSave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.ControlDSave] == true ||
						clearAll == true)
					{
						if (this._performDControl == false)
						{
							this._drABORh[ARTIFICIAL.ControlD] = DBNull.Value;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.ControlDGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.ControlDRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.ControlDSave] = false;
							}
						}
						else if (this._drABORh.IsNull(ARTIFICIAL.ControlD) == false)
						{
							this._drABORh[ARTIFICIAL.ControlD] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.ControlDGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.ControlDRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.ControlDSave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.AboInterpSave] == true ||
						clearAll == true)
					{
						if (this._drABORh.IsNull(TABLE.ValidAboResult.AboInterp) == false)
						{
							this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.AboInterpGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AboInterpRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.AboInterpSave] = true;
							}
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.RhInterpSave] == true ||
						clearAll == true)
					{
						if (this._drABORh.IsNull(TABLE.ValidRhResult.RhInterp) == false)
						{
							this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
							if (clearAll == true)
							{
								this._drABORh[ARTIFICIAL.RhInterpGuid] = DBNull.Value;
								this._drABORh[ARTIFICIAL.RhInterpRowVersion] = DBNull.Value;
								this._drABORh[ARTIFICIAL.RhInterpSave] = true;
							}
						}
					}
				}
				else
				{
					if ((bool)this._drABORh[ARTIFICIAL.AboInterpSave] == true ||
						clearAll == true)
					{
						this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
						if (clearAll == true)
						{
							this._drABORh[ARTIFICIAL.AboInterpGuid] = DBNull.Value;
							this._drABORh[ARTIFICIAL.AboInterpRowVersion] = DBNull.Value;
							this._drABORh[ARTIFICIAL.AboInterpSave] = true;
						}
					}
					if ((bool)this._drABORh[ARTIFICIAL.RhInterpSave] == true ||
						clearAll == true)
					{
						this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
						if (clearAll == true)
						{
							this._drABORh[ARTIFICIAL.RhInterpGuid] = DBNull.Value;
							this._drABORh[ARTIFICIAL.RhInterpRowVersion] = DBNull.Value;
							this._drABORh[ARTIFICIAL.RhInterpSave] = true;
						}
					}
				}

				this._drABORh[ARTIFICIAL.AboComment] = string.Empty;
				this._drABORh[ARTIFICIAL.RhComment] = string.Empty;
				this._drABORh[ARTIFICIAL.AboRhInconclusiveException] = DBNull.Value;
				this.cmbBoxAboComment.Text = string.Empty;
				this.cmbBoxRhComment.Text = string.Empty;

				UpdateIndicator();

				this.dgABORh.SetCurrentCell(0, 0);
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// </summary>
		private void AddCustomDataTableStyle()
		{
			_dgTableStyle = new DataGridTableStyle();
			_dgTableStyle.PreferredRowHeight = 22;

			_dgTableStyle.AllowSorting = false;
			_dgTableStyle.DataGrid = dgABORh;

			_dgTableStyle.HeaderFont = new Font("Arial", 8.25F, FontStyle.Regular, GraphicsUnit.Point, ((Byte)(0)), true);
			_dgTableStyle.HeaderForeColor = SystemColors.ControlText;
			_dgTableStyle.MappingName = "ABORh";
			_dgTableStyle.RowHeadersVisible = false;


			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			
			// 
			// AntiA
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Anti-A";
			_dcTextKeyTrapCol.MappingName = TABLE.ValidAboResult.AntiA;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// AntiB
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Anti-B";
			_dcTextKeyTrapCol.MappingName = TABLE.ValidAboResult.AntiB;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// AntiAB
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Anti-A,B";
			_dcTextKeyTrapCol.MappingName = TABLE.ValidAboResult.AntiAB;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// A1Cells
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "A1 Cells";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.A1Cells;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// BCells
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "B Cells";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.BCells;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// AntiD
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Anti-D";
			_dcTextKeyTrapCol.MappingName = TABLE.ValidRhResult.AntiD;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// ControlD
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "D Control";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.ControlD;
			_dcTextKeyTrapCol.Width = 60;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// AboInterp
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "ABO Interp.";
			_dcTextKeyTrapCol.MappingName = TABLE.ValidAboResult.AboInterp;
			_dcTextKeyTrapCol.Width = 65;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// RhInterp
			// 
			_dcTextKeyTrapCol = new DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Rh Interp.";
			_dcTextKeyTrapCol.MappingName = TABLE.ValidRhResult.RhInterp;
			_dcTextKeyTrapCol.Width = 65;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);

			// 
			// AboComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "ABO Comments";
			_dcTextBox.MappingName = ARTIFICIAL.AboComment;
			_dcTextBox.Width = 110;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			_dcTextBox.TextBox.Controls.Add(cmbBoxAboComment);
			cmbBoxAboComment.BringToFront();
			cmbBoxAboComment.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);

			// 
			// RhComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Rh Comments";
			_dcTextBox.MappingName = ARTIFICIAL.RhComment;
			_dcTextBox.Width = 100;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			_dcTextBox.TextBox.Controls.Add(cmbBoxRhComment);
			cmbBoxRhComment.BringToFront();
			cmbBoxRhComment.MouseDown += new MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
	
			// 
			// dcPatientGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Patient.PatientGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcPatientSpecimenGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.PatientSpecimen.PatientSpecimenGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcOrderedTestGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.OrderedTestGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcOrderableTestID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcInitialABO
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InitialABO;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcInitialRh
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.InitialRh;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcSystemABO
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.SystemABO;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcSystemRh
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.SystemRh;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
		
			// 
			// dcPartiallyCompleted
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAntiASave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiASave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAntiBSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiBSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAntiABSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiABSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcA1CellsSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.A1CellsSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcBCellsSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.BCellsSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAntiDSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiDSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcControlDSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ControlDSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAboInterpSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AboInterpSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcRhInterpSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RhInterpSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// AntiAGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiAGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// AntiBGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiBGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// AntiABGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiABGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// A1CellsGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.A1CellsGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// BCellsGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.BCellsGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// AntiDGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiDGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// DControlGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = "DControlGuid";
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// AboInterpGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AboInterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// RhInterpGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RhInterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// AntiARowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiARowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// AntiBRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiBRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// AntiABRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiABRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// A1CellsRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.A1CellsRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// BCellsRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.BCellsRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// AntiDRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntiDRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// DControlRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = "DControlRowVersion";
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// AboInterpRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AboInterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			
			// 
			// RhInterpRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RhInterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcCannedCommentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.CannedComment.CannedCommentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcCprsOrderNumber
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.CprsOrderNumber;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcRowVersionOrderedTest
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OrderedTestRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAboRhInconclusiveException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AboRhInconclusiveException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAboRhDiscrepancyException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AboRhDiscrepancyException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcRepeatAboRhDiscrepancyException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.RepeatAboRhDiscrepancyException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcEmergencyIssueExceptions
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.EmergencyIssueExceptions;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcCorrectedResultIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.SpecimenTest.CorrectedResultIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcRackGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Rack.RackGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcAboRhChangeIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.SpecimenTest.AboRhChangeIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			// 
			// dcIndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			dgABORh.TableStyles.Add(_dgTableStyle);				

		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// BR_2.28
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void _dcTextKeyTrapCol_TextBoxKeyPress(object sender, KeyPressEventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgABORh.CurrentCell.RowNumber;
				int column = this.dgABORh.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
				bool findNextCell = false;
				bool updateIndicator = false;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if (!char.IsLetterOrDigit(e.KeyChar))
				{
					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}
			
				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression

				if (column == 8)  // ABO interp
				{
					regPattern = @"(\A[ABOI]\z)|(\AAB\z)";
					//CR 2781 forcing the validation of entered results to prevent user from saving partial ABO/Rh results
					updateIndicator = true;
				}
				else if (column == 9)  // Rh interp
				{
					regPattern = @"(\A[PNI]\z)";
					findNextCell = true;
				}
				else if (column == 1 || column == 2 ||		// Anti-A	Anti-B
					column == 4 || column == 5 ||			// A1	B
					column == 6)							// Anti-D
				{
					regPattern = @"(\A[HWFM01234R]\z)";
					findNextCell = true;
				}
				else if (column == 3)							// Anti-A,B
				{
					regPattern = @"(\A[HWFM01234RX]\z)";
					findNextCell = true;
				}
				else if (column == 7)							// D-Control
				{
					regPattern = @"(\A[HWFM01234RX]\z)";
					findNextCell = true;
				}

				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening
					this._keyPressEventHandled = true;
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					DataTable dt = ((DataView)this.dgABORh.DataSource).Table;
					dt.Rows[row][column] = c.Text;

					//CR 2781 forcing the validation of entered results to prevent user from saving partial ABO/Rh results
					if (updateIndicator)
					{
						UpdateIndicator();
						this.dgABORh.Refresh();
						OnCellChanged(EventArgs.Empty);
					}

					if (findNextCell)
					{
						FindNextCell();
					}
					this._keyPressEventHandled = false;
				}
				else
				{
					//BR_2.28
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
				}
			
				e.Handled = true;
				return;			
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles the "Delete" key which is not being handled by the KeyPress event (CR 2781)
		/// This event will also fire when user tries to enter invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void _dcTextKeyTrapCol_TextChanged(object sender, EventArgs e)
		{
			//if the grid just received focus do not continue executing this event
			if (this.dgABORh.GridEntered == true)
			{
				this.dgABORh.GridEntered = false;
				return;
			}

			if (this._keyPressEventHandled || this.dgABORh.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgABORh.CurrentCell.RowNumber;
				int column = this.dgABORh.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgABORh.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";
						if (column == 8)  // ABO interp
						{
							regPattern = @"(\A[ABOI]\z)|(\AAB\z)";
						}
						else if (column == 9)  // Rh interp
						{
							regPattern = @"(\A[PNI]\z)";
						}
						else if (column == 1 || column == 2 ||		// Anti-A	Anti-B
							column == 4 || column == 5 ||			// A1	B
							column == 6)							// Anti-D
						{
							regPattern = @"(\A[HWFM01234R]\z)";
						}
						else if (column == 3)							// Anti-A,B
						{
							regPattern = @"(\A[HWFM01234RX]\z)";
						}
						else if (column == 7)							// D-Control
						{
							regPattern = @"(\A[HWFM01234RX]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							UpdateIndicator();
							this.dgABORh.Refresh();
							OnCellChanged(EventArgs.Empty);
							this._keyPressEventHandled = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent this from happening
							this._keyPressEventHandled = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandled = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
					//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandled = true;
						dt.Rows[row][column] = "";
						UpdateIndicator();
						this.dgABORh.Refresh();
						OnCellChanged(EventArgs.Empty);
						this._keyPressEventHandled = false;
					}
				}
			}
		}

		/// <summary>
		/// Move to the next cell
		/// </summary>
		private void FindNextCell()
		{
			if (this.dgABORh.CurrentCell.ColumnNumber < 11)
				this.dgABORh.SetCurrentCell(this.dgABORh.CurrentCell.RowNumber,this.dgABORh.CurrentCell.ColumnNumber + 1);
			else
				this.dgABORh.SetCurrentCell(this.dgABORh.CurrentCell.RowNumber,1);
		}

		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// BR_52.07, BR_52.08, BR_52.11, BR_56.29, TT_52.03
		/// </summary>
		private void UpdateIndicator()
		{
			string ABOInterp, RhInterp, techAbo, techRh, historicAbo, historicRh;
			bool showOverrideMsgs = true;
			string previousAboInterp = string.Empty;
			string previousRhInterp = string.Empty;
			DataTable dtPreviousResults = new DataTable();

			if ((bool)this._drABORh[ARTIFICIAL.AboInterpSave] == false &&
				(bool)this._drABORh[ARTIFICIAL.RhInterpSave] == false)
				showOverrideMsgs = false;

			if (showOverrideMsgs == false && 
				this._drABORh[TABLE.ValidAboResult.AboInterp].ToString().Trim() != string.Empty && 
				this._drABORh[TABLE.ValidRhResult.RhInterp].ToString().Trim() != string.Empty)
			{
				this.btnClear.Enabled = false;
				enableInvalidation = false;
			}

			//if (this._division.ServiceTypeIndicator == true ||
			//(this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			//CRT - 101405 - The Partially Completed check will allow Transfusion-Only sites to enter here when returning from save
			if (this._division.ServiceTypeIndicator == true)
			{
					if (this._drABORh[TABLE.ValidAboResult.AntiA].ToString().Trim() == string.Empty ||
						this._drABORh[TABLE.ValidAboResult.AntiB].ToString().Trim() == string.Empty ||
						(this._drABORh[TABLE.ValidAboResult.AntiAB].ToString().Trim() == string.Empty &&
						this._drABORh.IsNull(TABLE.ValidAboResult.AntiAB) == false) ||
						this._drABORh[ARTIFICIAL.A1Cells].ToString().Trim() == string.Empty ||
						this._drABORh[ARTIFICIAL.BCells].ToString().Trim() == string.Empty ||
						this._drABORh[TABLE.ValidRhResult.AntiD].ToString().Trim() == string.Empty ||
						(this._drABORh[ARTIFICIAL.ControlD].ToString().Trim() == string.Empty &&
						this._drABORh.IsNull(ARTIFICIAL.ControlD) == false))
					{
						this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
						this._drABORh[ARTIFICIAL.AboInterpSave] = true;
						this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
						this._drABORh[ARTIFICIAL.RhInterpSave] = true;
					}

					ABOInterp = InterpretABO(_drABORh[TABLE.ValidAboResult.AntiA].ToString(),
						_drABORh[TABLE.ValidAboResult.AntiB].ToString(),
						_drABORh[TABLE.ValidAboResult.AntiAB].ToString(),
						_drABORh[ARTIFICIAL.A1Cells].ToString(),
						_drABORh[ARTIFICIAL.BCells].ToString());

					RhInterp = InterpretRh(_drABORh[TABLE.ValidRhResult.AntiD].ToString(),
						_drABORh[ARTIFICIAL.ControlD].ToString());

					//there are missing test results
				if (ABOInterp == "X" || RhInterp == "X")
				{
					if (this.dgABORh.CurrentCell.ColumnNumber == 8 ||
						this.dgABORh.CurrentCell.ColumnNumber == 9)
					{
						MessageBox.Show(Common.StrRes.ValidMsg.Common.DataGridAboRh().ResString);
						this.dgABORh.SetCurrentCell(0, 2);
					}

					_drABORh[ARTIFICIAL.PartiallyCompleted] = true;
					_drABORh[ARTIFICIAL.Indicator] = string.Empty;
					_drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
				}
				else
				{
					//all test results were entered - validating the row status

					if (_drABORh[TABLE.ValidAboResult.AboInterp].ToString() == string.Empty ||
						_drABORh[TABLE.ValidRhResult.RhInterp].ToString() == string.Empty)
					{
						//CR 2781 if only ABO or Rh interp was entered
						if (_drABORh[TABLE.ValidAboResult.AboInterp].ToString() != string.Empty ||
							_drABORh[TABLE.ValidRhResult.RhInterp].ToString() != string.Empty)
						{
							_drABORh[ARTIFICIAL.PartiallyCompleted] = true;
							_drABORh[ARTIFICIAL.Indicator] = "E";
							_drABORh[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC056.ABOAndRhMustBeEntered().ResString;
						}
						else
						{
							_drABORh[ARTIFICIAL.PartiallyCompleted] = true;
							_drABORh[ARTIFICIAL.Indicator] = string.Empty;
							_drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
						}
					}
					else
					{
						if (_drABORh.IsNull(TABLE.SpecimenTest.AboRhChangeIndicator) == false)
						{
							if ((bool)_drABORh[TABLE.SpecimenTest.AboRhChangeIndicator] == true)
							{
								_drABORh[ARTIFICIAL.Indicator] = "V";
								_drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
								_drABORh[ARTIFICIAL.PartiallyCompleted] = false;
								return;
							}
						}

						_drABORh[ARTIFICIAL.PartiallyCompleted] = false;

						_drABORh[ARTIFICIAL.SystemABO] = ABOInterp;
						_drABORh[ARTIFICIAL.SystemRh] = RhInterp;

						techAbo = _drABORh[TABLE.ValidAboResult.AboInterp].ToString().Trim();
						techRh = _drABORh[TABLE.ValidRhResult.RhInterp].ToString().Trim();
						historicAbo = _drABORh[ARTIFICIAL.InitialABO].ToString().Trim();
						historicRh = _drABORh[ARTIFICIAL.InitialRh].ToString().Trim();

						if (ABOInterp == techAbo &&
							RhInterp == techRh &&
							(ABOInterp == historicAbo || historicAbo == string.Empty) &&
							(RhInterp == historicRh || historicRh == string.Empty))
						{
							_drABORh[ARTIFICIAL.Indicator] = "V";
							_drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
							_drABORh[ARTIFICIAL.AboRhInconclusiveException] = DBNull.Value;
							_drABORh[ARTIFICIAL.AboRhDiscrepancyException] = DBNull.Value;
							_drABORh[ARTIFICIAL.RepeatAboRhDiscrepancyException] = DBNull.Value;
						}
						else if (historicAbo != string.Empty &&
							historicRh != string.Empty &&
							historicAbo == techAbo &&
							historicRh == techRh &&
							(ABOInterp == "I" || RhInterp == "I"))
						{
							//52.08 52.11
                            //CR 3412 Enhanced Tech or above
                            if (this.UserRole >= Common.UserRoleType.EnhancedTechnologist)
                            {
                                if (this._drABORh.IsNull(ARTIFICIAL.AboRhInconclusiveException) &&
                                    showOverrideMsgs == true)
                                {
                                    DlgOverrideComment dlg = new DlgOverrideComment("Inconclusive ABO/Rh typing", StrRes.SysErrMsg.UC052.InconclusiveABORhTyping().ResString, "PT");

                                    dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                                    VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                    dlg.ShowDialogFromLockedParent(parentForm, false);

                                    if (dlg.DialogResult == DialogResult.OK)
                                    {
                                        ExceptionReport exRep = new ExceptionReport(ExceptionType.Invalid_ABORh_typing_and_interpretation, dlg.Comment, Common.LogonUser.LogonUserName);
                                        exRep.GenerateExceptionPatientABORh(this._orderedTest.Patient, this._orderedTest.Specimen.SpecimenUid, ABOInterp, RhInterp, _drABORh[TABLE.ValidAboResult.AboInterp].ToString(), _drABORh[TABLE.ValidRhResult.RhInterp].ToString(), this._testingTech, this._testingDate);
                                        _drABORh[ARTIFICIAL.AboRhInconclusiveException] = exRep;
                                        _drABORh[ARTIFICIAL.Indicator] = "W";
                                        _drABORh[ARTIFICIAL.IndicatorMessage] = "Inconclusive ABO/Rh typing";
                                        this.dgABORh.SetCurrentCell(0, 9);
                                        this.dgABORh.SetCurrentCell(0, 10);
                                    }
                                    else
                                    {
                                        this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
                                        this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
                                        this._drABORh[ARTIFICIAL.Indicator] = string.Empty;
                                        this._drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                        this.dgABORh.SetCurrentCell(0, 8);
                                        return;
                                    }
                                }
                                else
                                {
                                    _drABORh[ARTIFICIAL.Indicator] = "W";
                                    _drABORh[ARTIFICIAL.IndicatorMessage] = "Inconclusive ABO/Rh typing";
                                }
                            }
                            //CR 3412 Regular Tech - do not allow saving
                            else
                            {
                                _drABORh[ARTIFICIAL.Indicator] = "E";
                                _drABORh[ARTIFICIAL.AboRhInconclusiveException] = DBNull.Value;
                                _drABORh[ARTIFICIAL.IndicatorMessage] = "Interpretation does not match entries. Please correct";
                                _drABORh[ARTIFICIAL.AboRhInconclusiveException] = DBNull.Value;
                                _drABORh[ARTIFICIAL.AboRhDiscrepancyException] = DBNull.Value;
                                _drABORh[ARTIFICIAL.RepeatAboRhDiscrepancyException] = DBNull.Value;
                            }
						}
							//BR_56.16
						else if (ABOInterp == techAbo &&
							RhInterp == techRh &&
							this.OrderedTest.OrderableTest.IndexOf("Repeat") != -1 &&
							this.OrderedTest.CheckForRepeatAboRhDiscrepancy(techAbo, techRh, ref previousAboInterp, ref previousRhInterp, ref dtPreviousResults) == true)
						{
							if (this._drABORh.IsNull(ARTIFICIAL.RepeatAboRhDiscrepancyException) &&
								showOverrideMsgs == true)
							{
								DlgOverrideComment dlg = new GUI.DlgOverrideComment(string.Empty, string.Empty, "PT");
								dlg.Title = "Discrepant Repeat ABO/Rh typing"; 
								dlg.Message = "Original and repeat ABO/Rh interpretation do not match. You must resolve the discrepancy before this specimen may be used. Continue to save?";

                                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                dlg.ShowDialogFromLockedParent(parentForm, false);
                                if (dlg.DialogResult == DialogResult.Cancel || dlg.DialogResult == DialogResult.Abort)
								{
									this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
									this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
									this._drABORh[ARTIFICIAL.Indicator] = string.Empty;
									this._drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
									this.dgABORh.SetCurrentCell(0, 8);
									return;
								}
								else
								{
									BOL.Patient patient = new Patient((Guid)this._drABORh[TABLE.Patient.PatientGuid]);
									DataTable dtAboRhHistory = patient.GetPatientAboRHHistory();
									Guid ActiveSpecimenGuid = (Guid)this._drABORh[TABLE.PatientSpecimen.PatientSpecimenGuid];
									BOL.Specimen specimen = new BOL.Specimen(ActiveSpecimenGuid);
						
									BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.ABORh_discrepancy, dlg.Comment, Common.LogonUser.LogonUserName);
									if (dtPreviousResults.Rows.Count > 0)
									{
										exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
											dtPreviousResults.Rows[0][TABLE.PatientSpecimen.SpecimenUid].ToString(),
											previousAboInterp, previousRhInterp,
											dtPreviousResults.Rows[0][TABLE.SpecimenTest.TestTechId].ToString(),
											dtPreviousResults.Rows[0][TABLE.SpecimenTest.EntryTechId].ToString(),
											dtPreviousResults.Rows[0][TABLE.SpecimenTest.DivisionCode].ToString(),
											(DateTime)dtPreviousResults.Rows[0][TABLE.SpecimenTest.TestDate],
											specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
											Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
									}
									else
									{
										exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
											"N/A",
											previousAboInterp, previousRhInterp,
											"N/A",
											"N/A",
											"N/A",
											DateTime.MinValue,
											specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
											Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
									}

									_drABORh[ARTIFICIAL.RepeatAboRhDiscrepancyException] = exRep;
									_drABORh[ARTIFICIAL.Indicator] = "W";
									_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant Repeat ABO/Rh typing";
									this.dgABORh.SetCurrentCell(0, 9);
									this.dgABORh.SetCurrentCell(0, 10);
								}
							}
							else
							{
								_drABORh[ARTIFICIAL.Indicator] = "W";
								_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant Repeat ABO/Rh typing";
							}
						}
						else if((ABOInterp == techAbo &&
							RhInterp == techRh &&
							(ABOInterp != historicAbo || RhInterp != historicRh)) ||
							//CR 3277 - if ABO is Inc check if tech Rh matches system Rh, if Rh is Inc check if tech ABO matches system ABO
                            (ABOInterp != "I" && techAbo == "I" && RhInterp == techRh) ||
	                        (RhInterp != "I" && techRh == "I" && ABOInterp == techAbo))

						{
							//BR_56.12
							if (this._drABORh.IsNull(ARTIFICIAL.AboRhDiscrepancyException) &&
								showOverrideMsgs == true)
							{
								
								DlgOverrideComment dlg = new GUI.DlgOverrideComment(string.Empty, string.Empty, "PT");
								dlg.Title = "Discrepant ABO/Rh typing"; 
								dlg.Message = "Current ABO/Rh does not match previous results. Enter a comment to continue. Click Cancel to clear the ABO/Rh testing results and interpretation from the screen.";

                                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                dlg.ShowDialogFromLockedParent(parentForm, false);

								if (dlg.DialogResult == DialogResult.OK)
								{
									BOL.Patient patient = new Patient((Guid)this._drABORh[TABLE.Patient.PatientGuid]);
									DataTable dtAboRhHistory = patient.GetPatientAboRHHistory();
									Guid ActiveSpecimenGuid = (Guid)this._drABORh[TABLE.PatientSpecimen.PatientSpecimenGuid];
									BOL.Specimen specimen = new BOL.Specimen(ActiveSpecimenGuid);
										
									BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.ABORh_discrepancy, dlg.Comment, Common.LogonUser.LogonUserName);
									if (dtAboRhHistory.Rows.Count > 0)
									{
										exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
											dtAboRhHistory.Rows[0][TABLE.PatientSpecimen.SpecimenUid].ToString(),
											historicAbo, historicRh,
											dtAboRhHistory.Rows[0][TABLE.SpecimenTest.TestTechId].ToString(),
											dtAboRhHistory.Rows[0][TABLE.SpecimenTest.EntryTechId].ToString(),
											dtAboRhHistory.Rows[0][TABLE.SpecimenTest.DivisionCode].ToString(),
											(DateTime)dtAboRhHistory.Rows[0][TABLE.SpecimenTest.TestDate],
											specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
											Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
									}
									else
									{
										exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
											"N/A",
											historicAbo, historicRh,
											"N/A",
											"N/A",
											"N/A",
											DateTime.MinValue,
											specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
											Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
									}

									_drABORh[ARTIFICIAL.AboRhDiscrepancyException] = exRep;
									_drABORh[ARTIFICIAL.Indicator] = "W";
									_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant ABO/Rh typing";
									this.dgABORh.SetCurrentCell(0, 9);
									this.dgABORh.SetCurrentCell(0, 10);
								}
								else
								{
									this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
									this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
									this._drABORh[ARTIFICIAL.Indicator] = string.Empty;
									this._drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
									this.dgABORh.SetCurrentCell(0, 8);
									return;
								}
							}
							else
							{
								_drABORh[ARTIFICIAL.Indicator] = "W";
								_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant ABO/Rh typing";
							}
						}
						else
						{
							_drABORh[ARTIFICIAL.Indicator] = "E";
							_drABORh[ARTIFICIAL.AboRhInconclusiveException] = DBNull.Value;
							_drABORh[ARTIFICIAL.IndicatorMessage] = "Interpretation does not match entries. Please correct";
							_drABORh[ARTIFICIAL.AboRhInconclusiveException] = DBNull.Value;
							_drABORh[ARTIFICIAL.AboRhDiscrepancyException] = DBNull.Value;
							_drABORh[ARTIFICIAL.RepeatAboRhDiscrepancyException] = DBNull.Value;
						}
					}
				}
			}
			else //transfusion only
			{
				techAbo = _drABORh[TABLE.ValidAboResult.AboInterp].ToString().Trim();
				techRh = _drABORh[TABLE.ValidRhResult.RhInterp].ToString().Trim();
				historicAbo = _drABORh[ARTIFICIAL.InitialABO].ToString().Trim();
				historicRh = _drABORh[ARTIFICIAL.InitialRh].ToString().Trim();

				if (techAbo != string.Empty && techRh != string.Empty)
				{
					//BR_56.16
					if (this.OrderedTest.OrderableTest.IndexOf("Repeat") != -1 &&
						this.OrderedTest.CheckForRepeatAboRhDiscrepancy(techAbo, techRh, ref previousAboInterp, ref previousRhInterp, ref dtPreviousResults) == true)
					{
						if (this._drABORh.IsNull(ARTIFICIAL.RepeatAboRhDiscrepancyException) &&
							showOverrideMsgs == true)
						{
							DlgOverrideComment dlg = new GUI.DlgOverrideComment(string.Empty, string.Empty, "PT");
							dlg.Title = "Discrepant Repeat ABO/Rh typing"; 
							dlg.Message = "Original and repeat ABO/Rh interpretation do not match. You must resolve the discrepancy before this specimen may be used. Continue to save?";

                            dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                            dlg.ShowDialogFromLockedParent(parentForm, false);

							if (dlg.DialogResult == DialogResult.Cancel || dlg.DialogResult == DialogResult.Abort)
							{
								this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
								this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
								this._drABORh[ARTIFICIAL.Indicator] = string.Empty;
								this._drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
								this.dgABORh.SetCurrentCell(0, 8);
								return;
							}
							else
							{
								BOL.Patient patient = new Patient((Guid)this._drABORh[TABLE.Patient.PatientGuid]);
								DataTable dtAboRhHistory = patient.GetPatientAboRHHistory();
								Guid ActiveSpecimenGuid = (Guid)this._drABORh[TABLE.PatientSpecimen.PatientSpecimenGuid];
								BOL.Specimen specimen = new BOL.Specimen(ActiveSpecimenGuid);
						
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.ABORh_discrepancy, dlg.Comment, Common.LogonUser.LogonUserName);
								if (dtPreviousResults.Rows.Count > 0)
								{
									exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
										dtPreviousResults.Rows[0][TABLE.PatientSpecimen.SpecimenUid].ToString(),
										previousAboInterp, previousRhInterp,
										dtPreviousResults.Rows[0][TABLE.SpecimenTest.TestTechId].ToString(),
										dtPreviousResults.Rows[0][TABLE.SpecimenTest.EntryTechId].ToString(),
										dtPreviousResults.Rows[0][TABLE.SpecimenTest.DivisionCode].ToString(),
										(DateTime)dtPreviousResults.Rows[0][TABLE.SpecimenTest.TestDate],
										specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
										Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
								}
								else
								{
									exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
										"N/A",
										previousAboInterp, previousRhInterp,
										"N/A",
										"N/A",
										"N/A",
										DateTime.MinValue,
										specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
										Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
								}

								_drABORh[ARTIFICIAL.RepeatAboRhDiscrepancyException] = exRep;
								_drABORh[ARTIFICIAL.Indicator] = "W";
								_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant Repeat ABO/Rh typing";
								this.dgABORh.SetCurrentCell(0, 9);
								this.dgABORh.SetCurrentCell(0, 10);
								_drABORh[ARTIFICIAL.PartiallyCompleted] = false;
							}
						}
						else
						{
							_drABORh[ARTIFICIAL.Indicator] = "W";
							_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant Repeat ABO/Rh typing";
							_drABORh[ARTIFICIAL.PartiallyCompleted] = false;
						}
					}
					else if ((techAbo != historicAbo || techRh != historicRh) &&
						(historicAbo != string.Empty && historicRh != string.Empty))
					{
						//BR_56.12
						if (this._drABORh.IsNull(ARTIFICIAL.AboRhDiscrepancyException) &&
							showOverrideMsgs == true)
						{
						
							DlgOverrideComment dlg = new GUI.DlgOverrideComment(string.Empty, string.Empty, "PT");
							dlg.Title = "Discrepant ABO/Rh typing"; 
							dlg.Message = "Current ABO/Rh does not match previous results. Enter a comment to continue. Click Cancel to clear the ABO/Rh testing results and interpretation from the screen.";

                            dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                            dlg.ShowDialogFromLockedParent(parentForm, false);

							if (dlg.DialogResult == DialogResult.OK)
							{
								BOL.Patient patient = new Patient((Guid)this._drABORh[TABLE.Patient.PatientGuid]);
								DataTable dtAboRhHistory = patient.GetPatientAboRHHistory();
								Guid ActiveSpecimenGuid = (Guid)this._drABORh[TABLE.PatientSpecimen.PatientSpecimenGuid];
								BOL.Specimen specimen = new BOL.Specimen(ActiveSpecimenGuid);
								
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.ABORh_discrepancy, dlg.Comment, Common.LogonUser.LogonUserName);
								if (dtAboRhHistory.Rows.Count > 0)
								{
									exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
										dtAboRhHistory.Rows[0][TABLE.PatientSpecimen.SpecimenUid].ToString(),
										historicAbo, historicRh,
										dtAboRhHistory.Rows[0][TABLE.SpecimenTest.TestTechId].ToString(),
										dtAboRhHistory.Rows[0][TABLE.SpecimenTest.EntryTechId].ToString(),
										dtAboRhHistory.Rows[0][TABLE.SpecimenTest.DivisionCode].ToString(),
										(DateTime)dtAboRhHistory.Rows[0][TABLE.SpecimenTest.TestDate],
										specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
										Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
								}
								else
								{
									exRep.GenerateExceptionPatientAboRhDiscrepancy(patient, 
										"N/A",
										historicAbo, historicRh,
										"N/A",
										"N/A",
										"N/A",
										DateTime.MinValue,
										specimen.SpecimenUid, techAbo, techRh, this.TestingTech, Common.LogonUser.LogonUserName,
										Common.LogonUser.LogonUserDivisionCode, this.TestingDate);
								}

								_drABORh[ARTIFICIAL.AboRhDiscrepancyException] = exRep;
								_drABORh[ARTIFICIAL.Indicator] = "W";
								_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant ABO/Rh typing";
								this.dgABORh.SetCurrentCell(0, 9);
								this.dgABORh.SetCurrentCell(0, 10);
								_drABORh[ARTIFICIAL.PartiallyCompleted] = false;
							}
							else
							{
								this._drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
								this._drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
								this._drABORh[ARTIFICIAL.Indicator] = string.Empty;
								this._drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
								this.dgABORh.SetCurrentCell(0, 8);
								return;
							}
						}
						else
						{
							_drABORh[ARTIFICIAL.Indicator] = "W";
							_drABORh[ARTIFICIAL.IndicatorMessage] = "Discrepant ABO/Rh typing";
							_drABORh[ARTIFICIAL.PartiallyCompleted] = false;
						}
					}
					else
					{
						_drABORh[ARTIFICIAL.Indicator] = "V";
						_drABORh[ARTIFICIAL.AboRhInconclusiveException] = DBNull.Value;
						_drABORh[ARTIFICIAL.AboRhDiscrepancyException] = DBNull.Value;
						_drABORh[ARTIFICIAL.RepeatAboRhDiscrepancyException] = DBNull.Value;
						_drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
						_drABORh[ARTIFICIAL.PartiallyCompleted] = false;
					}
				}
				else
				{
					if (techAbo == string.Empty && techRh == string.Empty)
					{
						_drABORh[ARTIFICIAL.Indicator] = string.Empty;
						_drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
						_drABORh[ARTIFICIAL.PartiallyCompleted] = true;
					}
					else
					{
						//CR 2781 if only ABO or Rh interp was entered
						_drABORh[ARTIFICIAL.PartiallyCompleted] = true;
						_drABORh[ARTIFICIAL.Indicator] = "E";
						_drABORh[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC056.ABOAndRhMustBeEntered().ResString;
					}
				}
			}

			if (_drABORh[TABLE.ValidAboResult.AboInterp].ToString().Trim() != string.Empty &&
				_drABORh[TABLE.ValidRhResult.RhInterp].ToString().Trim() != string.Empty &&
				_drABORh[ARTIFICIAL.InitialABO].ToString() != string.Empty &&
				_drABORh[ARTIFICIAL.InitialRh].ToString() != string.Empty)
			{
				//BR_56.29
				if (_drABORh[ARTIFICIAL.InitialABO].ToString() != _drABORh[TABLE.ValidAboResult.AboInterp].ToString() ||
					_drABORh[ARTIFICIAL.InitialRh].ToString() != _drABORh[TABLE.ValidRhResult.RhInterp].ToString())
				{
					if (this._drABORh.IsNull(ARTIFICIAL.EmergencyIssueExceptions) &&
						showOverrideMsgs == true)
					{
						DataTable dtIssuedUnits = BOL.OrderedTest.GetEmergencyIssuedUnitsForOrderedTest(this._orderedTest.OrderedTestGuid);
						if (dtIssuedUnits.Rows.Count > 0)
						{
							DlgOverrideComment dlg = new DlgOverrideComment( "ABO/Rh Mismatch", Common.StrRes.SysErrMsg.UC056.EmergencyUnitsIssued().ResString, "PT" );

                            dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                            dlg.ShowDialogFromLockedParent(parentForm, false);

							if (dlg.DialogResult == DialogResult.Cancel || dlg.DialogResult == DialogResult.Abort)
							{
								_drABORh[TABLE.ValidAboResult.AboInterp] = string.Empty;
								_drABORh[TABLE.ValidRhResult.RhInterp] = string.Empty;
								_drABORh[ARTIFICIAL.Indicator] = string.Empty;
								_drABORh[ARTIFICIAL.IndicatorMessage] = string.Empty;
								_drABORh[ARTIFICIAL.PartiallyCompleted] = true;
								this.dgABORh.SetCurrentCell(0, 8);
								return;
							}
							else
							{
								BOL.AboRh aboRH = new BOL.AboRh(Common.Utility.GetAboFromString(_drABORh[TABLE.ValidAboResult.AboInterp].ToString().Trim()), Common.Utility.GetRhFromString(_drABORh[TABLE.ValidRhResult.RhInterp].ToString().Trim()));
								ArrayList emergencyIssueExceptions = new ArrayList();
								foreach(DataRow drIssuedUnit in dtIssuedUnits.Rows)
								{
									BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_ER_issued_testing_problem, dlg.Comment, Common.LogonUser.LogonUserName);
									exRep.GenerateExceptionEmergencyIssueUnitTest((Guid)drIssuedUnit[TABLE.OrderedUnit.BloodUnitGuid], (Guid)this._drABORh[TABLE.Patient.PatientGuid], "ABO/Rh", aboRH.AboRHText, this.TestingTech);
									emergencyIssueExceptions.Add(exRep);
								}
								this._drABORh[ARTIFICIAL.EmergencyIssueExceptions] = emergencyIssueExceptions;
							}
						}
					}
				}
				else
				{
					this._drABORh[ARTIFICIAL.EmergencyIssueExceptions] = DBNull.Value;
				}
			}
		}

		/// <summary>
		/// Find the system interpretation of ABO testing
		/// BR_52.03, BR_52.06, TT_52.01
		/// </summary>
		/// <param name="AntiA"></param>
		/// <param name="AntiB"></param>
		/// <param name="AntiAB"></param>
		/// <param name="A1Cell"></param>
		/// <param name="BCell"></param>
		/// <returns></returns>
		private string InterpretABO(string AntiA, string AntiB, string AntiAB, string A1Cell, string BCell)
		{
			if (this._drABORh.IsNull(TABLE.ValidAboResult.AntiAB) == false)
			{
				if (AntiA == string.Empty || AntiB == string.Empty || AntiAB == string.Empty || A1Cell == string.Empty || BCell == string.Empty)
				{
					return "X";
				}
			}
			else
			{
				if (AntiA == string.Empty || AntiB == string.Empty || A1Cell == string.Empty || BCell == string.Empty)
				{
					return "X";
				}
			}

			if (resultLookup[AntiA].ToString() == "N" &&
				resultLookup[AntiB].ToString() == "N" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "N") &&
				resultLookup[A1Cell].ToString() == "P" &&
				resultLookup[BCell].ToString() == "P")
			{
				return "O";
			}
			else if (resultLookup[AntiA].ToString() == "P" &&
				resultLookup[AntiB].ToString() == "N" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "P") &&
				resultLookup[A1Cell].ToString() == "N" &&
				resultLookup[BCell].ToString() == "P")
			{
				return "A";
			}
			else if (resultLookup[AntiA].ToString() == "N" &&
				resultLookup[AntiB].ToString() == "P" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "P") &&
				resultLookup[A1Cell].ToString() == "P" &&
				resultLookup[BCell].ToString() == "N")
			{
				return "B";
			}
			else if (resultLookup[AntiA].ToString() == "P" &&
				resultLookup[AntiB].ToString() == "P" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "P") &&
				resultLookup[A1Cell].ToString() == "N" &&
				resultLookup[BCell].ToString() == "N")
			{
				return "AB";
			}
			else
			{
				return "I";
			}
		}

		/// <summary>
		/// Find the system interpretation of Rh testing
		/// BR_52.03, BR_52.06, TT_52.02
		/// </summary>
		/// <param name="AntiD"></param>
		/// <param name="DControl"></param>
		/// <returns></returns>
		private string InterpretRh(string AntiD, string DControl)
		{
			if (this._drABORh.IsNull(ARTIFICIAL.ControlD) == false)
			{
				if (AntiD == string.Empty || DControl == string.Empty)
				{
					return "X";
				}
			}
			else
			{
				if (AntiD == string.Empty)
				{
					return "X";
				}
			}
			
			if (resultLookup[AntiD].ToString() == "P" &&
				((resultLookup[DControl].ToString() == "N") || (resultLookup[DControl].ToString() == "X") || this._drABORh.IsNull(ARTIFICIAL.ControlD)))
			{
				return "P";
			}
			else if (resultLookup[AntiD].ToString() == "N" &&
				((resultLookup[DControl].ToString() == "N") || (resultLookup[DControl].ToString() == "X") || this._drABORh.IsNull(ARTIFICIAL.ControlD)))
			{
				return "N";
			}
			else
			{
				return "I";
			}
		}

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// </summary>
		/// <param name="column"></param>
		public void SetValidEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression
			
			if (column == 8)  // ABO interp
			{
				_validEntries = "A = Type A, B = Type B, AB = Type AB, O = Type O, I = Inconclusive";
			}
			else if (column == 9)  // Rh interp
			{
				_validEntries = "P = Positive, N = Negative, I = Inconclusive";
			}
			else if (column == 1 || column == 2 ||		// Anti-A	Anti-B
				column == 4 || column == 5 ||			// A1	B
				column == 6)							// Anti-D
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, H = Hemolysis, W = Weak, F = Mixed Field, R = Rouleaux, M = Microscopic";
			}
			else if (column == 3)							// Anti-A,B
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, H = Hemolysis, W = Weak, F = Mixed Field, R = Rouleaux, M = Microscopic\nX = Not Tested";
			}
			else if (column == 7)							// D-Control
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, \nH = Hemolysis, W = Weak, F = Mixed Field, R = Rouleaux, M = Microscopic, X = Not Tested";
			}
			else if (column == 10 || column == 11)		// ABO Comment, RH Comment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = "Read-Only";
			}
		}


		/// <summary>
		/// Handles the CellChanged event for datagrid. Controls the movement of the cursor
		/// on the gird and updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgABORh_CurrentCellChanged(object sender, EventArgs e)
		{

			try
			{
				//do not allow to focus on any visible cell when all the data are filled on the grid
				if ((bool)this._drABORh[ARTIFICIAL.AntiASave] == false &&
					(bool)this._drABORh[ARTIFICIAL.AntiBSave] == false &&
					(bool)this._drABORh[ARTIFICIAL.AntiABSave] == false &&
					(bool)this._drABORh[ARTIFICIAL.A1CellsSave] == false &&
					(bool)this._drABORh[ARTIFICIAL.BCellsSave] == false &&
					(bool)this._drABORh[ARTIFICIAL.AntiDSave] == false &&
					(bool)this._drABORh[ARTIFICIAL.ControlDSave] == false &&
					(bool)this._drABORh[ARTIFICIAL.AboInterpSave] == false &&
					(bool)this._drABORh[ARTIFICIAL.RhInterpSave] == false)
				{
					this.dgABORh.Enabled = false;
					return;
				}

				if (this.dgABORh.CurrentCell.ColumnNumber < 1)
					this.dgABORh.SetCurrentCell(this.dgABORh.CurrentCell.RowNumber, 1);

				if (this.dgABORh.CurrentCell.ColumnNumber > 11)
					this.dgABORh.SetCurrentCell(this.dgABORh.CurrentCell.RowNumber, 11);

				if (this._division.ServiceTypeIndicator == true ||
					this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					switch(this.dgABORh.CurrentCell.ColumnNumber)
					{
						case 1:
							if ((bool)this._drABORh[ARTIFICIAL.AntiASave] == false)
								this.FindNextCell();
							break;
						case 2:
							if ((bool)this._drABORh[ARTIFICIAL.AntiBSave] == false)
								this.FindNextCell();
							break;
						case 3:
							if ((bool)this._drABORh[ARTIFICIAL.AntiABSave] == false)
								this.FindNextCell();
							break;
						case 4:
							if ((bool)this._drABORh[ARTIFICIAL.A1CellsSave] == false)
								this.FindNextCell();
							break;
						case 5:
							if ((bool)this._drABORh[ARTIFICIAL.BCellsSave] == false)
								this.FindNextCell();
							break;
						case 6:
							if ((bool)this._drABORh[ARTIFICIAL.AntiDSave] == false)
								this.FindNextCell();
							break;
						case 7:
							if ((bool)this._drABORh[ARTIFICIAL.ControlDSave] == false)
								this.FindNextCell();
							break;
						case 8:
							if ((bool)this._drABORh[ARTIFICIAL.AboInterpSave] == false)
								this.FindNextCell();
							break;
						case 9:
							if ((bool)this._drABORh[ARTIFICIAL.RhInterpSave] == false)
								this.FindNextCell();
							break;
						case 10:
							if ((bool)this._drABORh[ARTIFICIAL.AboInterpSave] == false ||
								this._drABORh[TABLE.ValidAboResult.AboInterp].ToString() == string.Empty)
							{
								this.FindNextCell();
							}
							else
							{
								if (this.cmbBoxAboComment.Items.Count == 0)
								{
									DataTable dtCannedComments = CannedComment.GetCannedComments(this.DivisionCode, "PT");
									foreach (DataRow drComment in dtCannedComments.Rows)
									{
										this.cmbBoxAboComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
									}
								}
								this.cmbBoxAboComment.LookupEnabled = false;
								//CR 2777
								this.cmbBoxAboComment.Text = this._drABORh[ARTIFICIAL.AboComment].ToString();
								this.cmbBoxAboComment.Show();
								this.cmbBoxAboComment.Focus();
							}
							break;
						case 11:
							if ((bool)this._drABORh[ARTIFICIAL.RhInterpSave] == false ||
								this._drABORh[TABLE.ValidRhResult.RhInterp].ToString() == string.Empty)
							{
								this.FindNextCell();
							}
							else
							{
								if (this.cmbBoxRhComment.Items.Count == 0)
								{
									DataTable dtCannedComments = CannedComment.GetCannedComments(this.DivisionCode, "PT");
									foreach (DataRow drComment in dtCannedComments.Rows)
									{
										this.cmbBoxRhComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
									}
								}
								this.cmbBoxRhComment.LookupEnabled = false;
								//CR 2777
								this.cmbBoxRhComment.Text = this._drABORh[ARTIFICIAL.RhComment].ToString();
								this.cmbBoxRhComment.Show();
								this.cmbBoxRhComment.Focus();
							}
							break;
					}
				}
				else //transfusion only
				{
					if (this.dgABORh.CurrentCell.ColumnNumber < 8)
					{
						this.dgABORh.SetCurrentCell(this.dgABORh.CurrentCell.RowNumber, 8);
					}

					switch(this.dgABORh.CurrentCell.ColumnNumber)
					{
						case 10:
							if ((bool)this._drABORh[ARTIFICIAL.AboInterpSave] == false ||
								this._drABORh[TABLE.ValidAboResult.AboInterp].ToString() == string.Empty)
							{
								this.FindNextCell();
							}
							else
							{
								if (this.cmbBoxAboComment.Items.Count == 0)
								{
									DataTable dtCannedComments = CannedComment.GetCannedComments(this.DivisionCode, "PT");
									foreach (DataRow drComment in dtCannedComments.Rows)
									{
										this.cmbBoxAboComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
									}
								}
								//this.cmbBoxAboComment.LookupEnabled = false;
								this.cmbBoxAboComment.Show();
								this.cmbBoxAboComment.Focus();
							}
							break;
						case 11:
							if ((bool)this._drABORh[ARTIFICIAL.RhInterpSave] == false ||
								this._drABORh[TABLE.ValidRhResult.RhInterp].ToString() == string.Empty)
							{
								this.FindNextCell();
							}
							else
							{
								if (this.cmbBoxRhComment.Items.Count == 0)
								{
									DataTable dtCannedComments = CannedComment.GetCannedComments(this.DivisionCode, "PT");
									foreach (DataRow drComment in dtCannedComments.Rows)
									{
										this.cmbBoxRhComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
									}
								}
								//this.cmbBoxRhComment.LookupEnabled = false;
								this.cmbBoxRhComment.Show();
								this.cmbBoxRhComment.Focus();
							}
							break;
					}
				}

				UpdateIndicator();
				SetValidEntries(this.dgABORh.CurrentCell.ColumnNumber);
				OnCellChanged(EventArgs.Empty);

			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Clears the test results and restores the grid to the initial state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, EventArgs e)
		{
			ClearGrid();
			this.OnUserActivity();
		}

		/// <summary>
		/// Clears the grid. This method is public because it is being invoked by context menu from main form of the UC_56
		/// BR_52.09
		/// </summary>
		public void ClearGrid()
		{
			if (this._drABORh[TABLE.ValidAboResult.AntiA].ToString().Trim() == string.Empty &&
				this._drABORh[TABLE.ValidAboResult.AntiB].ToString().Trim() == string.Empty &&
				(this._drABORh[TABLE.ValidAboResult.AntiAB].ToString().Trim() == string.Empty ||
				this._drABORh.IsNull(TABLE.ValidAboResult.AntiAB) == true) &&
				this._drABORh[ARTIFICIAL.A1Cells].ToString().Trim() == string.Empty &&
				this._drABORh[ARTIFICIAL.BCells].ToString().Trim() == string.Empty &&
				this._drABORh[TABLE.ValidRhResult.AntiD].ToString().Trim() == string.Empty &&
				(this._drABORh[ARTIFICIAL.ControlD].ToString().Trim() == string.Empty ||
				this._drABORh.IsNull(ARTIFICIAL.ControlD) == true))
			{
				return;
			}


			if ((bool)this._drABORh[ARTIFICIAL.AntiASave] == false ||
				(bool)this._drABORh[ARTIFICIAL.AntiBSave] == false ||
				((bool)this._drABORh[ARTIFICIAL.AntiABSave] == false &&
				this._drABORh.IsNull(TABLE.ValidAboResult.AntiAB) == false) ||
				(bool)this._drABORh[ARTIFICIAL.A1CellsSave] == false ||
				(bool)this._drABORh[ARTIFICIAL.BCellsSave] == false ||
				(bool)this._drABORh[ARTIFICIAL.AntiDSave] == false ||
				((bool)this._drABORh[ARTIFICIAL.ControlDSave] == false &&
				this._drABORh.IsNull(ARTIFICIAL.ControlD) == false))
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Inactivate test results", "Do you want to inactivate test results for this task?", "PT");

                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);

				if (dlg.DialogResult == DialogResult.OK)
				{
					this.ClearTestResults(false);
					ExceptionReport exRep = new ExceptionReport(ExceptionType.Previously_recorded_results_inactivated, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionPatientTestInactivated(this._orderedTest, this._testingTech);

					if (this._orderedTest.OrderableTestId != (int)OrderableTest.TAS)
					{
						this._orderedTest.InactivateTestResults(exRep, UpdateFunction.DataGridAboRHClearGrid);
					}
					else
					{
						this._orderedTest.InactivateTestResultsForOrderableTest(exRep, (int)OrderableTest.ABORh, UpdateFunction.DataGridAboRHClearGrid);
					}
					this.ClearTestResults(true);
				}
				else
					return;
			}
			else
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.ClearTestResults()) == DialogResult.Yes)
				{
					this.ClearTestResults(false);
				}
				else
					return;
			}
			this._drABORh[ARTIFICIAL.OrderedTestRowVersion] = this._orderedTest.RowVersion;
			if (this._orderedTest.OrderableTestId == (int)Common.OrderableTest.TAS)
			{
				OnRowVersionChanged(this._orderedTest.RowVersion);
			}
		}

		/// <summary>
		/// Copy the comment entered in the combo box to the cell
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBoxAboComment_Validating(object sender, CancelEventArgs e)
		{
			try
			{
				this._drABORh[ARTIFICIAL.AboComment] = this.cmbBoxAboComment.Text;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Copy the comment entered in the combo box to the cell
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBoxRhComment_Validating(object sender, CancelEventArgs e)
		{
			try
			{
				this._drABORh[ARTIFICIAL.RhComment] = this.cmbBoxRhComment.Text;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void _dcTextKeyTrapCol_MouseClick(object sender, MouseEventArgs e)
		{
			try
			{
				if (e.Button == MouseButtons.Right)
				{
					if (this._drABORh != null)
					{
						this.ContextMenu.Show(this, new Point(e.X, e.Y));
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABORh_Enter(object sender, EventArgs e)
		{
			try
			{
				this.dgABORh.SetCurrentCell(0, 1);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABORh_Leave(object sender, EventArgs e)
		{
			try
			{
				this.UpdateIndicator();
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABORh_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						this.SelectNextControl(this.dgABORh,true,true,false,false);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgABORh_SizeChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this.dgABORh.TableStyles.Count>0)
				{
					DataGridTableStyle tblStyle = this.dgABORh.TableStyles["ABORh"];
					//
				    if (tblStyle != null)
				    {
				        tblStyle.GridColumnStyles[ARTIFICIAL.AboComment].Width = (int)((this.dgABORh.Width -
				                                                                        (tblStyle.GridColumnStyles[ARTIFICIAL.Indicator].Width +
				                                                                         tblStyle.GridColumnStyles[TABLE.ValidAboResult.AntiA].Width +
				                                                                         tblStyle.GridColumnStyles[TABLE.ValidAboResult.AntiB].Width +
				                                                                         tblStyle.GridColumnStyles[TABLE.ValidAboResult.AntiAB].Width +
				                                                                         tblStyle.GridColumnStyles[ARTIFICIAL.A1Cells].Width +
				                                                                         tblStyle.GridColumnStyles[ARTIFICIAL.BCells].Width +
				                                                                         tblStyle.GridColumnStyles[TABLE.ValidRhResult.AntiD].Width +
				                                                                         tblStyle.GridColumnStyles[ARTIFICIAL.ControlD].Width +
				                                                                         tblStyle.GridColumnStyles[TABLE.ValidAboResult.AboInterp].Width +
				                                                                         tblStyle.GridColumnStyles[TABLE.ValidRhResult.RhInterp].Width + 7)) / 2);
				        tblStyle.GridColumnStyles[ARTIFICIAL.RhComment].Width = tblStyle.GridColumnStyles[ARTIFICIAL.AboComment].Width;
				        this.cmbBoxAboComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.AboComment].Width;
				        this.cmbBoxRhComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.RhComment].Width;
				    }
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Invoke row changed event
		/// </summary>
		/// <param name="rowVersion"></param>
		protected virtual void OnRowVersionChanged(byte[] rowVersion)
		{
			if (RowVersionChanged != null)
				RowVersionChanged(this, EventArgs.Empty, rowVersion);
		}
	}
}
